Public Class Form1
    Inherits System.Windows.Forms.Form
    Dim scanint As Int16
    Dim display(5) As Label
    Dim description(5) As Label
    Dim winclose As Boolean = False

    ' Added the code for control array in sub below
#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        ' Configure the array for the List Box
        display(0) = lbldata1
        display(1) = lbldata2
        display(2) = lbldata3
        display(3) = lbldata4
        display(4) = lbldata5
        ' configure array for description box
        description(0) = lbltitle1
        description(1) = lbltitle2
        description(2) = lbltitle3
        description(3) = lbltitle4
        description(4) = lbltitle5


    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents frmIPconfig As System.Windows.Forms.GroupBox
    Friend WithEvents cmdconnect As System.Windows.Forms.Button
    Friend WithEvents txtIPadd As System.Windows.Forms.TextBox
    Friend WithEvents tmrscan As System.Windows.Forms.Timer
    Friend WithEvents cmdscanon As System.Windows.Forms.Button
    Friend WithEvents cmdstop As System.Windows.Forms.Button
    Friend WithEvents frmdata As System.Windows.Forms.GroupBox
    Friend WithEvents lbldata1 As System.Windows.Forms.Label
    Friend WithEvents lbldata2 As System.Windows.Forms.Label
    Friend WithEvents lbldata3 As System.Windows.Forms.Label
    Friend WithEvents lbldata5 As System.Windows.Forms.Label
    Friend WithEvents lbldata4 As System.Windows.Forms.Label
    Friend WithEvents AxWinsock1 As AxMSWinsockLib.AxWinsock
    Friend WithEvents lbltitle1 As System.Windows.Forms.Label
    Friend WithEvents lbltitle2 As System.Windows.Forms.Label
    Friend WithEvents lbltitle3 As System.Windows.Forms.Label
    Friend WithEvents lbltitle4 As System.Windows.Forms.Label
    Friend WithEvents lbltitle5 As System.Windows.Forms.Label
    Friend WithEvents cmdend As System.Windows.Forms.Button
    Friend WithEvents PictureBox1 As System.Windows.Forms.PictureBox
    Friend WithEvents lblinp As System.Windows.Forms.Label
    Friend WithEvents lblinput As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
        Me.frmIPconfig = New System.Windows.Forms.GroupBox()
        Me.txtIPadd = New System.Windows.Forms.TextBox()
        Me.cmdconnect = New System.Windows.Forms.Button()
        Me.tmrscan = New System.Windows.Forms.Timer(Me.components)
        Me.cmdscanon = New System.Windows.Forms.Button()
        Me.cmdstop = New System.Windows.Forms.Button()
        Me.frmdata = New System.Windows.Forms.GroupBox()
        Me.lbltitle5 = New System.Windows.Forms.Label()
        Me.lbltitle4 = New System.Windows.Forms.Label()
        Me.lbltitle3 = New System.Windows.Forms.Label()
        Me.lbltitle2 = New System.Windows.Forms.Label()
        Me.lbltitle1 = New System.Windows.Forms.Label()
        Me.lbldata4 = New System.Windows.Forms.Label()
        Me.lbldata5 = New System.Windows.Forms.Label()
        Me.lbldata3 = New System.Windows.Forms.Label()
        Me.lbldata2 = New System.Windows.Forms.Label()
        Me.lbldata1 = New System.Windows.Forms.Label()
        Me.AxWinsock1 = New AxMSWinsockLib.AxWinsock()
        Me.cmdend = New System.Windows.Forms.Button()
        Me.PictureBox1 = New System.Windows.Forms.PictureBox()
        Me.lblinp = New System.Windows.Forms.Label()
        Me.lblinput = New System.Windows.Forms.Label()
        Me.frmIPconfig.SuspendLayout()
        Me.frmdata.SuspendLayout()
        CType(Me.AxWinsock1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'frmIPconfig
        '
        Me.frmIPconfig.Controls.AddRange(New System.Windows.Forms.Control() {Me.txtIPadd, Me.cmdconnect})
        Me.frmIPconfig.Location = New System.Drawing.Point(136, 48)
        Me.frmIPconfig.Name = "frmIPconfig"
        Me.frmIPconfig.Size = New System.Drawing.Size(136, 128)
        Me.frmIPconfig.TabIndex = 2
        Me.frmIPconfig.TabStop = False
        Me.frmIPconfig.Text = "IP Configure"
        '
        'txtIPadd
        '
        Me.txtIPadd.Location = New System.Drawing.Point(24, 80)
        Me.txtIPadd.Name = "txtIPadd"
        Me.txtIPadd.Size = New System.Drawing.Size(96, 20)
        Me.txtIPadd.TabIndex = 3
        Me.txtIPadd.Text = "192.168.1.10"
        '
        'cmdconnect
        '
        Me.cmdconnect.Location = New System.Drawing.Point(16, 32)
        Me.cmdconnect.Name = "cmdconnect"
        Me.cmdconnect.Size = New System.Drawing.Size(56, 32)
        Me.cmdconnect.TabIndex = 2
        Me.cmdconnect.Text = "Connect"
        '
        'tmrscan
        '
        '
        'cmdscanon
        '
        Me.cmdscanon.Location = New System.Drawing.Point(16, 56)
        Me.cmdscanon.Name = "cmdscanon"
        Me.cmdscanon.Size = New System.Drawing.Size(80, 24)
        Me.cmdscanon.TabIndex = 3
        Me.cmdscanon.Text = "Start Scan"
        '
        'cmdstop
        '
        Me.cmdstop.Location = New System.Drawing.Point(16, 88)
        Me.cmdstop.Name = "cmdstop"
        Me.cmdstop.Size = New System.Drawing.Size(80, 24)
        Me.cmdstop.TabIndex = 4
        Me.cmdstop.Text = "Scan Stop"
        '
        'frmdata
        '
        Me.frmdata.Controls.AddRange(New System.Windows.Forms.Control() {Me.lbltitle5, Me.lbltitle4, Me.lbltitle3, Me.lbltitle2, Me.lbltitle1, Me.lbldata4, Me.lbldata5, Me.lbldata3, Me.lbldata2, Me.lbldata1})
        Me.frmdata.Location = New System.Drawing.Point(296, 56)
        Me.frmdata.Name = "frmdata"
        Me.frmdata.Size = New System.Drawing.Size(192, 208)
        Me.frmdata.TabIndex = 5
        Me.frmdata.TabStop = False
        Me.frmdata.Text = "Data"
        '
        'lbltitle5
        '
        Me.lbltitle5.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbltitle5.Location = New System.Drawing.Point(8, 152)
        Me.lbltitle5.Name = "lbltitle5"
        Me.lbltitle5.Size = New System.Drawing.Size(80, 24)
        Me.lbltitle5.TabIndex = 9
        Me.lbltitle5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbltitle4
        '
        Me.lbltitle4.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbltitle4.Location = New System.Drawing.Point(8, 120)
        Me.lbltitle4.Name = "lbltitle4"
        Me.lbltitle4.Size = New System.Drawing.Size(80, 24)
        Me.lbltitle4.TabIndex = 8
        Me.lbltitle4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbltitle3
        '
        Me.lbltitle3.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbltitle3.Location = New System.Drawing.Point(8, 88)
        Me.lbltitle3.Name = "lbltitle3"
        Me.lbltitle3.Size = New System.Drawing.Size(80, 24)
        Me.lbltitle3.TabIndex = 7
        Me.lbltitle3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbltitle2
        '
        Me.lbltitle2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbltitle2.Location = New System.Drawing.Point(8, 56)
        Me.lbltitle2.Name = "lbltitle2"
        Me.lbltitle2.Size = New System.Drawing.Size(80, 24)
        Me.lbltitle2.TabIndex = 6
        Me.lbltitle2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbltitle1
        '
        Me.lbltitle1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbltitle1.Location = New System.Drawing.Point(8, 24)
        Me.lbltitle1.Name = "lbltitle1"
        Me.lbltitle1.Size = New System.Drawing.Size(80, 24)
        Me.lbltitle1.TabIndex = 5
        Me.lbltitle1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbldata4
        '
        Me.lbldata4.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.lbldata4.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbldata4.Location = New System.Drawing.Point(96, 120)
        Me.lbldata4.Name = "lbldata4"
        Me.lbldata4.Size = New System.Drawing.Size(80, 24)
        Me.lbldata4.TabIndex = 4
        Me.lbldata4.Tag = "gf"
        Me.lbldata4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbldata5
        '
        Me.lbldata5.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.lbldata5.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbldata5.Location = New System.Drawing.Point(96, 152)
        Me.lbldata5.Name = "lbldata5"
        Me.lbldata5.Size = New System.Drawing.Size(80, 24)
        Me.lbldata5.TabIndex = 3
        Me.lbldata5.Tag = "gf"
        Me.lbldata5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbldata3
        '
        Me.lbldata3.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.lbldata3.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbldata3.Location = New System.Drawing.Point(96, 88)
        Me.lbldata3.Name = "lbldata3"
        Me.lbldata3.Size = New System.Drawing.Size(80, 24)
        Me.lbldata3.TabIndex = 2
        Me.lbldata3.Tag = "gf"
        Me.lbldata3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbldata2
        '
        Me.lbldata2.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.lbldata2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbldata2.Location = New System.Drawing.Point(96, 56)
        Me.lbldata2.Name = "lbldata2"
        Me.lbldata2.Size = New System.Drawing.Size(80, 24)
        Me.lbldata2.TabIndex = 1
        Me.lbldata2.Tag = "gf"
        Me.lbldata2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'lbldata1
        '
        Me.lbldata1.BackColor = System.Drawing.SystemColors.InactiveCaptionText
        Me.lbldata1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lbldata1.Location = New System.Drawing.Point(96, 24)
        Me.lbldata1.Name = "lbldata1"
        Me.lbldata1.Size = New System.Drawing.Size(80, 24)
        Me.lbldata1.TabIndex = 0
        Me.lbldata1.Tag = "gf"
        Me.lbldata1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'AxWinsock1
        '
        Me.AxWinsock1.Enabled = True
        Me.AxWinsock1.Location = New System.Drawing.Point(40, 216)
        Me.AxWinsock1.Name = "AxWinsock1"
        Me.AxWinsock1.OcxState = CType(resources.GetObject("AxWinsock1.OcxState"), System.Windows.Forms.AxHost.State)
        Me.AxWinsock1.Size = New System.Drawing.Size(28, 28)
        Me.AxWinsock1.TabIndex = 6
        '
        'cmdend
        '
        Me.cmdend.Location = New System.Drawing.Point(16, 120)
        Me.cmdend.Name = "cmdend"
        Me.cmdend.Size = New System.Drawing.Size(80, 24)
        Me.cmdend.TabIndex = 7
        Me.cmdend.Text = "Exit"
        '
        'PictureBox1
        '
        Me.PictureBox1.Image = CType(resources.GetObject("PictureBox1.Image"), System.Drawing.Bitmap)
        Me.PictureBox1.Location = New System.Drawing.Point(8, 8)
        Me.PictureBox1.Name = "PictureBox1"
        Me.PictureBox1.Size = New System.Drawing.Size(528, 32)
        Me.PictureBox1.TabIndex = 8
        Me.PictureBox1.TabStop = False
        '
        'lblinp
        '
        Me.lblinp.AutoSize = True
        Me.lblinp.Location = New System.Drawing.Point(184, 184)
        Me.lblinp.Name = "lblinp"
        Me.lblinp.Size = New System.Drawing.Size(0, 13)
        Me.lblinp.TabIndex = 16
        '
        'lblinput
        '
        Me.lblinput.AutoSize = True
        Me.lblinput.BackColor = System.Drawing.Color.FromArgb(CType(64, Byte), CType(64, Byte), CType(64, Byte))
        Me.lblinput.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lblinput.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, (System.Drawing.FontStyle.Bold Or System.Drawing.FontStyle.Italic), System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblinput.ForeColor = System.Drawing.Color.Lime
        Me.lblinput.Location = New System.Drawing.Point(192, 208)
        Me.lblinput.Name = "lblinput"
        Me.lblinput.Size = New System.Drawing.Size(0, 15)
        Me.lblinput.TabIndex = 15
        Me.lblinput.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(552, 273)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.lblinp, Me.lblinput, Me.PictureBox1, Me.cmdend, Me.AxWinsock1, Me.frmdata, Me.cmdstop, Me.cmdscanon, Me.frmIPconfig})
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "Form1"
        Me.Text = "Simple 5 Channel Scan Demo"
        Me.frmIPconfig.ResumeLayout(False)
        Me.frmdata.ResumeLayout(False)
        CType(Me.AxWinsock1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    ' This program shows how to use the Winsock Active X control that was used in
    ' VB6 in VB.Net.  There is a socket class that can also be used as well
    '
    ' This program just shows a simple 5 channel Temperature scan and displays the 
    'Data onto the form.
    '
    'EEB
    '




    Private Sub cmdconnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdconnect.Click
        With AxWinsock1
            .RemotePort = 1394
            .RemoteHost = txtIPadd.Text
            .Connect()



        End With
    End Sub

   

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrscan.Tick

       
        AxWinsock1.SendData("READ?" & vbCr)

    End Sub

    Private Sub cmdscanon_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdscanon.Click
        tmrscan.Interval = scanint
        tmrscan.Enabled = True


    End Sub

    Private Sub cmdstop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdstop.Click
        tmrscan.Enabled = False

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim x As Integer

        scanint = 2000
        For x = 0 To 4
            description(x).Text = "Channel "
        Next
    End Sub



    Private Sub AxWinsock1_ConnectEvent(ByVal sender As Object, ByVal e As System.EventArgs) Handles AxWinsock1.ConnectEvent
        frmIPconfig.Enabled = False

        With AxWinsock1
            .SendData("*RST" & vbCr)
            .SendData("FORM:ELEM READ,CHAN" & vbCr)                    ' format the data
            .SendData("UNIT:TEMP F,(@101:105)" & vbCr)                 ' Set for F Order is important. must be done first
            .SendData("FUNC 'TEMP', (@101:105)" & vbCr)                ' Set up the channels for temp
            .SendData("TEMP:TRAN TC,(@101:105)" & vbCr)                ' Config for Thermocouple
            .SendData("TEMP:TC:TYPE J,(@101:105)" & vbCr)              ' Config for K thermocouple
            .SendData("TEMP:NPLC .01,(@101:105)" & vbCr)
            ' .SendData "SENS:TEMP:APER .9,(@101:105)" & vbCr           ' Config Speed
            .SendData("TRAC:CLE" & vbCr)                               ' Clear Buffer
            ' .SendData "INIT:CONT OFF" & vbCr                           ' Disable continuous initiation
            .SendData("TRIG:COUN 1" & vbCr)                            ' Set number of scans
            .SendData("SAMP:COUN 5" & vbCr)                           ' Set number of channels
            .SendData("ROUT:SCAN (@101:105)" & vbCr)                   ' Set scan list
            .SendData("ROUT:SCAN:TSO IMM" & vbCr)                      ' Start scan when enabled
            .SendData("ROUT:SCAN:LSEL INT" & vbCr)                     ' Enable scan
            '.SendData "read?" & vbCr
            .SendData("SYST:FRSW?" & vbCr)
        End With

    End Sub

    Private Sub AxWinsock1_DataArrival(ByVal sender As Object, ByVal e As AxMSWinsockLib.DMSWinsockControlEvents_DataArrivalEvent) Handles AxWinsock1.DataArrival
        Dim strdata As String
        Dim y As Integer
        Dim z As Integer
        Dim data(5) As String
        Dim strhold As Single
        Dim x As Int16


        ''You have to allocate some space for the incoming data !!
        strdata = New String(Chr(0), e.bytesTotal)
        z = 0


        AxWinsock1.GetData(strdata)
        If strdata.Length = 2 Then
            lblinp.Text = "Input Switch"
            If strdata = 1 Then
                lblinput.Text = "Front"
            Else
                lblinput.Text = "Rear"
            End If
        Else

            ' Put the , delimited string into and array
            data = Split(strdata, ",")
            ' lbound = first array location of data and ubound = last array location of data
            For y = LBound(data) To UBound(data) Step 2

                strhold = Val(data(y))
                display(z).Text = Format(strhold, "##,##0.0000") & " F"
                z = z + 1

            Next y
            AxWinsock1.SendData("SYST:FRSW?" & vbCr)
        End If
    End Sub


    Private Sub cmdend_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdend.Click
        With AxWinsock1
            winclose = True
            .SendData("*rst" & vbCr)

        End With

    End Sub


    Private Sub AxWinsock1_Error(ByVal sender As Object, ByVal e As AxMSWinsockLib.DMSWinsockControlEvents_ErrorEvent) Handles AxWinsock1.Error
        Dim estring As Object
        Dim enumb As Object
        estring = e.description
        enumb = e.number

        Select Case e.number
            Case Is = 10060
                MessageBox.Show("Cannot establish connection, check network settings and try again", "Time Out Error !!", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Case Is = 10061
                MessageBox.Show("Cannot establish connection, instrument has an open connection.  Either close the software running the instrument or power cycle the 2701 to close the connection.", "Open Connection Error !!", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Case Else
                MessageBox.Show("Error has occured : " + enumb + estring)


        End Select

    End Sub

    Private Sub AxWinsock1_SendComplete(ByVal sender As Object, ByVal e As System.EventArgs) Handles AxWinsock1.SendComplete
        If winclose = True Then
            AxWinsock1.Close()
            End
        End If
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)

    End Sub
End Class
